function [I_Drain_pA, I_Source_pA, I_Ref_pA, t] = pAContinuousSignalImport(file)
    %% Import data from text file
    % Script for importing data from the following text file:
    %
    %    filename: M:\DuarteSanchezDF\2019 10\P3HT Single Molecule\P3HT SM32
    %
    % Auto-generated by MATLAB on 14-Oct-2019 12:03:26

    %% Setup the Import Options and import the data
    opts = delimitedTextImportOptions("NumVariables", 8);

    % Specify range and delimiter
    opts.DataLines = [1, Inf];
    opts.Delimiter = "\t";

    % Specify column names and types
    opts.VariableNames = ["Var1", "t_ms", "I_Source", "I_Drain", "Var5", "Var6", "Var7", "I_Ref"];
    opts.SelectedVariableNames = ["t_ms", "I_Source", "I_Drain",  "I_Ref"];
    opts.VariableTypes = ["string", "double", "double", "double", "string", "string", "string", "double"];

    % Specify file level properties
    opts.ExtraColumnsRule = "ignore";
    opts.EmptyLineRule = "read";

    % Specify variable properties
    opts = setvaropts(opts, ["Var1", "Var5", "Var6", "Var7"], "WhitespaceRule", "preserve");
    opts = setvaropts(opts, ["Var1", "Var5", "Var6", "Var7"], "EmptyFieldRule", "auto");

    % Import the data
    tbl = readtable(file, opts);

    %% Convert to output type
    t_ms = tbl.t_ms;
    I_Drain = tbl.I_Drain;
    I_Source = tbl.I_Source;
    I_Ref = tbl.I_Ref;

    %% Clear temporary variables
    clear opts tbl

    %% Unit conversion
    t= t_ms*1e-3;
    I_Drain_pA= I_Drain/1e-12;
    I_Source_pA= I_Source/1e-12;
    I_Ref_pA= I_Ref/1e-12;
end